#!/usr/bin/env gosh
;; -*- coding: euc-jp -*-

(use text.html-lite)
(use text.tree)

(define *version* "0.3.1")
(define *last-update* "Thu Mar 24 2011")

(define-syntax def
  (syntax-rules (en ja procedure method)
	((_ en)
     '())
    ((_ ja)
	 '())
	((_ en (synopsis x y z ...) rest ...)
     (cons
      (def (synopsis x z ...))
      (def en rest ...)))
	((_ ja (synopsis x y z ...) rest ...)
     (cons
      (def (synopsis y z ...))
      (def ja rest ...)))
	((_ ((procedure (name arg ...) ...) (p ...) z ...))
     (list
      (html:h3 (html:span :class "type" "procedure") ": "
               (html:span :class "procedure" (html-escape-string (symbol->string 'name))) " "
               (cons (html:span :class "argument" 'arg) " ") ...)
      ...
      (map
       (lambda (x)
         (if (string? x)
             (html:p (html-escape-string x))
             (html:pre (html-escape-string (list-ref '(z ...) x)))))
       (list p ...))
      (html:hr)))
	((_ ((method (name arg ...) ...) (p ...) z ...))
	 (list
	  (html:h3 (html:span :class "type" "method") ": "
			   (html:span :class "method" (html-escape-string (symbol->string 'name))) " "
			   (cons (html:span :class "argument" (html-escape-string (x->string 'arg))) " ") ...)
	  ...
      (map
       (lambda (x)
         (if (string? x)
             (html:p (html-escape-string x))
             (html:pre (html-escape-string (list-ref '(z ...) x)))))
       (list p ...))
	  (html:hr)))
	((_ ((type name ...) (p ...) z ...))
	 (list
	  (html:h3 (html:span :class "type" 'type) ": "
			   (html:span :class 'type (html-escape-string (symbol->string 'name))))
	  ...
      (map
       (lambda (x)
         (if (string? x)
             (html:p (html-escape-string x))
             (html:pre (html-escape-string (list-ref '(z ...) x)))))
       (list p ...))
	  (html:hr)))))

(define-macro (c-layer-api lang)
  `(def ,lang

	   ((class <gd-image>)
		("A fundamental class. Its instance has a foreign pointer to GD's \"gdImage\". It is expected as the first argument of most of procedures whose names starting with prefix `gd-image-'.")
		("ܤȤʤ륤᡼Υ饹Ǥºݤˤ GD  \"gdImage\" ؤ foreign pointer Ǥ\"gd-image-\" (C Ǥ \"gdImage\")ǻϤޤۤȤɤμ³1ȤѤޤ"))

	   ((class <gd-font>)
		("Another fundamental class. Its instance has a foreign pointer to GD's \"gdFont\". You can get its instance by any of \"gd-font-get-*\".")
		("ܤȤʤեȤΥ饹Ǥºݤˤ GD  \"gdFont\" ؤ foreign pointer Ǥ³ \"gd-font-get-*\" Τ줫ǥ󥹥󥹤뤳ȤǤޤ"))

	   ((variable gdMaxColors gdAlphaMax gdAlphaOpaque gdAlphaTransparent gdRedMax gdGreenMax gdBlueMax
				  gdFTEX_LINESPACE gdFTEX_CHARMAP gdFTEX_RESOLUTION gdFTEX_DISABLE_KERNING
				  gdFTEX_XSHOW gdFTEX_FONTPATHNAME gdFTEX_FONTCONFIG gdFTEX_RETURNFONTPATHNAME
				  gdFTEX_Unicode gdFTEX_Shift_JIS gdFTEX_Big5
				  gdArc gdPie gdChord gdNoFill gdEdged
				  GD2_CHUNKSIZE GD2_CHUNKSIZE_MIN GD2_CHUNKSIZE_MAX
				  GD2_VERS
				  GD2_FMT_RAW GD2_FMT_COMPRESSED
				  GD_CMP_IMAGE GD_CMP_NUM_COLORS GD_CMP_COLOR GD_CMP_SIZE_X GD_CMP_SIZE_Y
				  GD_CMP_TRANSPARENT GD_CMP_BACKGROUND GD_CMP_INTERLACE GD_CMP_TRUECOLOR
				  GD_RESOLUTION)
		("Each of these is an integer corresponding to its C-alternative.")
		("줾 C Ʊ̾Ʊͤͤ˻ޤ"))

	   ((variable GD2_ID)
		("It has a string value same with its C-equivalent.")
		("C Ʊ̾Ʊʸͤ˻ޤ"))

	   ((procedure (gd-true-color-get-alpha c)
				   (gd-true-color-get-red c)
				   (gd-true-color-get-green c)
				   (gd-true-color-get-blue c))
		("Each of these is equivalent to gdTrueColorGetAlpha, gdTrueColorGetRed, gdTrueColorGetGreen, or gdTrueColorGetBlue respectively.")
		("줾 gdTrueColorGetAlpha, gdTrueColorGetRed, gdTrueColorGetGreen, gdTrueColorGetBlue бޤ"))

	   ((procedure (gd-alpha-blend dest src))
		("This is equivalent to gdAlphaBlend.")
		("gdAlphaBlend бޤ"))

	   ((procedure (gd-image-create sx sy)
				   (gd-image-create-palette sx sy)
				   (gd-image-create-true-color sx sy))
		("Each of these is a constructor of <gd-image> which is equivalent to gdImageCreate, gdImageCreatePalette, or gdImageCreateTrueColor respectively. If failed these return #f.")
		("줾 gdImageCreate, gdImageCreatePalette, gdImageCreateTrueColor б<gd-image> ֥Ȥ֤ޤԤ #f ֤ޤ"))

	   ((procedure (gd-image-create-from-png path)
				   (gd-image-create-from-gif path)
				   (gd-image-create-from-jpeg path)
				   (gd-image-create-from-wbmp path)
				   (gd-image-create-from-xbm path)
				   (gd-image-create-from-gd path)
				   (gd-image-create-from-gd2 path)
				   (gd-image-create-from-gd2-part path))
		("Like C's gdImageCreateFrom* family, one of these creates a <gd-image> object from a source file in its particular image format. Unlike its C's equivalents, it treats the string-value single argument as a path of source. The file handle has been closed before successful return. In case of failure #f is returned.")
		("C  gdImageCreateFrom* ؿƱͤˡμ³Ϥ줾Υ᡼եޥåȤ˱ƥե뤫 <gd-image> ֥Ȥޤ C ƱδؿȰۤʤꡢ˥եΥѥʸǻꤷޤ³äˤϥեΥϥɥĤƤޤԤˤ #f ֤ޤ"))

	   ((procedure (gd-image-create-from-xpm path))
		("The gdImageCreateFromXpm equivalent, which returns a <gd-image> object in case of success, otherwise #f.")
		("C  gdImageCreateFromXpm б³Ǥˤ <gd-image> ֥Ȥ򡢼Ԥˤ #f ֤ޤ"))

	   ((procedure (gd-image-destroy im))
		("Call gdImageDestroy() explicitly. Different from the C version it is idempotent, meaning that it can be repeated safely."
		 "(Because of gc, it is little necessary to use this procedure.)")
		("<gd-image> ֥ȤλؤƤ \"gdImage\" ꥽ФŪ gdImageDestroy ƤӤޤ֤ƤФƤǤ"
		 "(˴ؤ̤¤Τʤ¤ꡢä꥽β gc ǤƤƹޤ)"))

       ((procedure (gd-image-set-pixel im x y color)
				   (gd-image-get-pixel im x y)
				   (gd-image-get-true-color-pixel im x y))
        ("Each of these is equivalent to gdImageSetPixel, gdImageGetPixel, or gdImageGetTrueColorPixel respectively.")
        ("줾 gdImageSetPixel, gdImageGetPixel, gdImageGetTrueColorPixel бޤ"))

       ((procedure (gd-image-line im x1 y1 x2 y2 color))
        ("The gdImageLine alternative.")
        ("ؿ gdImageLine б³Ǥ"))

       ((procedure (gd-image-rectangle im x1 y1 x2 y2 color)
				   (gd-image-filled-rectangle im x1 y1 x2 y2 color))
        ("Each of these is equivalent to gdImageRectangle or gdImageFilledRectangle respectively.")
        ("줾 gdImageRectangle, gdImageFilledRectangle б³Ǥ"))

       ((procedure (gd-image-set-clip im x1 y1 x2 y2)
				   (gd-image-get-clip im))
        ("As well as gdImageSetClip the former one clips a rectangle from the image for subsequent drawing. The latter returns the current clip with four integer-values.")
        ("gdImageSetClip Ʊͤ gd-image-set-clip ϰʸŬѤ륯åΰꤷޤgd-image-get-clip ϸߤΥåΰκɸɽ4Ĥο֤ͤޤ"))

	   ((procedure (gd-image-bounds-safe im x y))
		("Given the coordinates of a point, return either 1 (if it is in the current clip) or 0 (otherwise). You should use it in order to check whether the coordinates is suitable or not for arguments of another procedure, e.g. gd-image-fill.")
		("åΰκɸ줿1򡢤ʤ0֤ޤgd-image-fill ʤɤμ³ΰŬɸɤǧ뤿ˤδؿѤ٤Ǥ"))

	   ((procedure (gd-image-char im f x y c color)
				   (gd-image-char-up im f x y c color))
		("Put a single byte character on the given image with the font provided by a gd-font-get-*. If you would like to print a string containing multibyte characters, try procedure \"gd-image-string-ft\" or method \"string!\".")
		("᡼1ХʸϤޤ2ΥեȤϼ³ gd-font-get-* ƤޥХʸޤʸϤˤϼ³ \"gd-image-string-ft\" ޤϥ᥽å \"string!\" ȤäƤ"))

	   ((procedure (gd-image-string im f x y s color)
				   (gd-image-string-up im f x y s color))
		("Put a string consising of single byte characters, with the font provided by a gd-font-get-*. If you would like to print a string containing multibyte characters, try gd-image-string-ft.")
		("᡼1ХʸʤʸϤޤ2ΥեȤϼ³ gd-font-get-* ƤޥХʸޤʸϤˤϼ³ \"gd-image-string-ft\" ޤϥ᥽å \"string!\" ȤäƤ"))

	   ((procedure (gd-image-string-ft im fg fontlist ptsize angle x y str))
		("Print a string with a FreeType font specified by the path `fontlist'. Unlike the original version, it return *four* pairs of integers which represent the coordinates of the points surrounding the bounding rectangle, and coming lower-left, lower-right, upper-right, and upper-left in that order. "
		 "It is also possible to obtain these values efficiently, i.e. without printing `str', by giving #f to `im'."
		 "If your gosh is configured with option \"--enable-multibyte=utf-8\", then congratulations! and multibyte characters will be available in `str' (with an appropriate font, of course). Otherwise you had better use method \"string!\".")
		("`fontlist' ǥѥꤹ뤳Ȥ FreeType եȤѤʸ񤭽Фޤꥸʥ C δؿȰۤʤꡢμ³*4*Υڥ֤줾줬ζϤɸ(˺塢)ɽޤ"
		 "`im'  #f ϤȤ褻ˤζκɸΨŪ˵뤳ȤǤޤ"
		 "gosh  \"--enable-multibyte=utf-8\" ȤץդǥӥɤƤ `str' ǥޥХʸѤǤޤǤʤϥ᥽å \"string!\" λѤͤƤ"))

	   ((procedure (gd-image-polygon im points pointsTotal color)
				   (gd-image-filled-polygon im points pointsTotal color)
				   (gd-image-open-polygon im points pointsTotal color))
		("The second argument of these procedure, which expresses a sequence of points, must satisfy the following conditions:"
		 "- of type proper <list>, and"
		 "- its elements are of type <pair> and consist of integers which correspond to the coordinates of a point."
		 "Furthermore the third one is expected to be a non-negative integer.")
		("μ³Ϥ줾 gdImagePolygon, gdImageFilledPolygon, gdImageOpenPolygon бޤɸɽ2Ȥƽ۴Ĥ̵ꥹȤꤷޤΥꥹȤγǤϺɸɽڥǤʤФʤޤ󡣤3Ǥ뤳Ȥޤ"))

	   ((procedure (gd-image-color-allocate im r g b)
				   (gd-image-color-allocate-alpha im r g b a)
				   (gd-image-color-closest im r g b)
				   (gd-image-color-closest-alpha im r g b a)
				   (gd-image-color-closest-hwb im r g b)
				   (gd-image-color-exact im r g b)
				   (gd-image-color-exact-alpha im r g b a)
				   (gd-image-color-resolve im r g b)
				   (gd-image-color-resolve-alpha im r g b a))
		("Each of these corresponds to gdImageColorAllocate, gdImageColorAllocateAlpha, gdImageColorClosest, gdImageColorClosestAlpha, gdImageColorClosestHWB, gdImageColorExact, gdImageColorExactAlpha, gdImageColorResolve, or gdImageColorResolveAlpha respectively.")
		("줾 C δؿ gdImageColorAllocate, gdImageColorAllocateAlpha, gdImageColorClosest, gdImageColorClosestAlpha, gdImageColorClosestHWB, gdImageColorExact, gdImageColorExactAlpha, gdImageColorResolve, gdImageColorResolveAlpha бޤ"))

	   ((procedure (gd-true-color r g b)
				   (gd-true-color-alpha r g b a))
		("Same as gdTrueColor or gdTrueColorAlpha resp. for each.")
		("줾 C δؿ gdTrueColor, gdTrueColorAlpha бޤ"))

	   ((procedure (gd-image-color-deallocate im color))
		("Similar to gdImageColorDeallocate it reduces a color in the palette.")
		("gdImageColorDeallocate Ʊͤ˥ѥåȤο˴ѤǤ褦ˤޤ"))

	   ((procedure (gd-image-create-palette-from-true-color im ditherFlag colorsWanted)
				   (gd-image-true-color-to-palette im ditherFlag colorsWanted))
		("Both convert a true color image into the palette one while the latter destructively returns into the result argument `im'. If the former fails it returns #f")
		(" true color ᡼ѥåȥ᡼ѴޤԤͿ줿᡼˲Ūѹΰ˷̤֤ޤޤԤԤ #f ֤ޤ"))

	   ((procedure (gd-image-color-transparent im color))
		("The gdImageColorTransparent equivalent.")
		("ؿ gdImageColorTransparent бޤ"))

	   ((procedure (gd-image-palette-copy dst src))
		("The gdImagePaletteCopy alternative.")
		("ؿ gdImagePaletteCopy бޤ"))

	   ((procedure (gd-image-filled-arc im cx cy w h s e color style)
				   (gd-image-arc im cx cy w h s e color))
		("Like gdImageFilledArc or gdImageArc respectively.")
		("줾 gdImageFilledArc, gdImageArc бޤ"))

	   ((procedure (gd-image-filled-ellipse im cx cy w h color))
		("The gdImageFilledEllipse equivalent.")
		("ؿ gdImageFilledEllipse бޤ"))

	   ((procedure (gd-image-fill-to-border im x y border color)
				   (gd-image-fill im x y color))
		("Each of these is equivalent to gdImageFillToBorder or gdImageFill respectively.")
		("줾 gdImageFillToBorder, gdImageFill бޤ"))

	   ((procedure (gd-image-copy dst src dstX dstY srcX srcY w h)
				   (gd-image-copy-merge dst src dstX dstY srcX srcY w h pct)
				   (gd-image-copy-merge-gray dst src dstX dstY srcX srcY w h pct)
				   (gd-image-copy-resized dst src dstX dstY srcX srcY dstW dstH srcW srdH)
				   (gd-image-copy-resampled dst src dstX dstY srcX srcY dstW dstH srcW srdH)
				   (gd-image-copy-rotated dst src dstX dstY srcX srcY srcWidth srdHeight angle))
		("Note that some of these will preserve the palette of the given destination image as well as their C-equivalents.")
		("μ³ˤб gdImageCopy* ؿƱ褦Ϳ줿ԡΥѥåȤѹʤΤ⤢뤳ȤդƤ"))

	   ((procedure (gd-image-set-brush im brush)
				   (gd-image-set-tile im tile)
				   (gd-image-set-anti-aliased im c)
				   (gd-image-set-anti-aliased-dont-blend im c dont_blend)
				   (gd-image-set-thickness im thickness)
				   (gd-image-interlace im interlaceArg)
				   (gd-image-alpha-blending im blending)
				   (gd-image-save-alpha im saveFlag))
		("The following functions are called respectively: gdImageSetBrush, gdImageSetTile, gdImageSetAntiAliased, gdImageSetAntiAliasedDontBlend, gdImageSetThickness, gdImageInterlace, gdImageAlphaBlending, and gdImageSaveAlpha.")
		("줾 gdImageSetBrush, gdImageSetTile, gdImageSetAntiAliased, gdImageSetAntiAliasedDontBlend, gdImageSetThickness, gdImageInterlace, gdImageAlphaBlending, gdImageSaveAlpha бޤ"))

		((procedure (gd-image-set-style im style styleLength))
		 ("Given style as a list, call gdImageSetStyle.")
		 ("style ꥹȤȤͿ뤳Ȥ gdImageSetStyle ƤӤޤ"))

 	   ((procedure (gd-image-true-color im))
		("It returns 0 for a palette image, otherwise non-0.")
		("ѥåȥ᡼Ϳ줿0򡢤ʤ0ʳο֤ͤޤ"))

	   ((procedure (gd-image-sx im)
				   (gd-image-sy im))
		("Each returns the sx(`width') or sy(`height') of the image respectively.")
		("줾Ϳ줿᡼β⤷ϽĤ֤ޤ"))

	   ((procedure (gd-image-colors-total im))
		("Given a palette image it returns the number of currently allocated colors in the palette.")
		("ѥåȥ᡼Ϳ줿硢ѥåȤο֤ޤ"))

	   ((procedure (gd-image-red im c)
				   (gd-image-green im c)
				   (gd-image-blue im c)
				   (gd-image-alpha im c))
		("Each of these corresponds to gdImageRed, gdImageGreen, gdImageBlue, or gdImageAlpha respectively.")
		("줾 gdImageRed, gdImageGreen, gdImageBlue, gdImageAlpha бޤ"))

	   ((procedure (gd-image-get-transparent im)
				   (gd-image-get-interlaced im))
		("Each of these is equivalent to gdImageGetTransparent or gdImageGetInterlaced respectively.")
		("줾 gdImageGetTransparent, gdImageGetInterlaced бޤ"))

	   ((procedure (gd-image-palette-pixel im x y)
				   (gd-image-true-color-pixel im x y))
		("These inherits the bounds-unsafe nature from their C-alternatives.")
		("μ³ϥޥ gdImagePalettePixel  gdImageTrueColorPixel ľܸƤӽФᡢŬڤɤ˳ǧɬפǤ礦"))

	   ((procedure (gd-image-compare im1 im2))
		("Return 0 If two images are same wrt displayed components, otherwise non-0.")
		("Ϳ줿2ĤΥ᡼褵빽Ǥ˴ؤ0򡢤ʤ0ʳο֤ͤޤ"))

	   ((procedure (gd-image-square-to-circle im radius)
				   (gd-image-sharpen im pct))
		("Like gdImageSquareToCircle or gdImageSharpen respectively. The former returns #f in case of failure.")
		("줾 gdImageSquareToCircle, gdImageSharpen бޤԤϼԤ #f ֤ޤ"))

	   ((procedure (gd-font-get-giant)
				   (gd-font-get-large)
				   (gd-font-get-medium-bold)
				   (gd-font-get-small)
				   (gd-font-get-tiny))
		("One of these procedures give you the font of size Giant, Large, MediumBold, Small, or Tiny respectively, which is for gd-image-char, gd-image-string etc. When the specified size is unavailable it return #f.")
		("μ³Ϥ줾쥵 Giant, Large, MediumBold, Small, Tiny ΥեȤ֤ޤΥեȤ gd-image-char  gd-image-string ΰѤޤեȤʤ #f ֤ޤ"))
	   ))

(define-macro (simple-api lang)
  `(def ,lang
		((constant *gd-version*)
		 ("The version of GD library. Detected at the compile time of the package.")
		 ("GD ΥСGauche-gd Υѥ˼ΤǤ"))

		((constant *gd-features*)
		 ("A list of symbols which mean available features of GD."
		  "Possible symbols in the list: fontconfig freetype gif jpeg png xpm."
          "You can also use feature identifiers of form 'gauche.ext.graphics.gd.*' with cond-expand."
          "Note that they are available after loading the module.")
		 ("ͭ GD εǽɽܥΥꥹȡ"
		  "ΥꥹȤ˴ޤޤǽΤ륷ܥϰʲ̤: fontconfig freetype gif jpeg png xpm"
          "ޤ 'gauche.ext.graphics.gd.*' Ȥ feature indentifiers  cond-expand ȤȤ˻ȤȤǤޤ"
          " identifiers ϥ⥸塼ΥɸѤǤޤ"))

		((parameter current-gd-image-format)
		 ("It is expected to keep a symbol which decides the image format taken with \"read-gd-image\" and/or \"write\" unless specified.")
		 ("GD Υ᡼ΥեޥåȤ˰¸ʤݲƤޤϤԤݤΥեޥåȤˤʤäƤ뤳Ȥ褯ޤ\"read-gd-image\"  \"write\"  Υѥ᡼ͤ򻲾ȤΤǡäѤǤޤ"))

		((procedure (with-gd-image-format fmt thunk))
		 ("Call `thunk' with the parameterized \"current-gd-image-format\" of value `fmt'.")
		 ("嵭 \"current-gd-image-format\" ͤŪ `fmt' ˤ `thunk' ƤӤޤ \"current-gd-image-format\" ͤޤ`thunk' ͤμ³ͤǤ"))

		((method (read-gd-image (port <port>) &optional (fmt <symbol>) &keyword x y w h))
		 ("Read a image with or without format `fmt' (such as \"gif\", \"jpe\", \"jpeg\", \"jpg\", \"png\", \"wbmp\", \"gd\", and \"gd2\"). See also \"current-gd-image-format\", or #f if an error occurs."
		  "The keywords `x', `y', `w' and `h' are only for the GD2 format and corresponding to the 2nd, 3rd, 4th and 5th argument of \"gdImageCreateFromGd2PartCtx\" respectively.")
		 ("ݡ `port' 饤᡼Ϥޤ顼ξ #f ֤ޤեޥå `fmt' ȤƼͤ \"gif\", \"jpe\", \"jpeg\", \"jpg\", \"png\", \"wbmp\", \"gd\", ڤ \"gd2\" Ǥ\"current-gd-image-format\" ⻲ȤƤ"
		  " `x'`y'`w' ڤ `h'  GD2 եޥåȤФƤΤŬѤ졢줾 \"gdImageCreateFromGd2PartCtx\"  2ܡ3ܡ4ܵڤ5ܤΰбޤ"))

		((method (write-as (im <gd-image>) (fmt <symbol>) port &keyword quality foreground))
		 ("Put a image `im' with format `fmt' (such as \"gif\", \"jpe\", \"jpeg\", \"jpg\", \"png\", and \"wbmp\")."
		  "If the JPEG format specified, you can suggest the `quality' of the resulting image. The keyword is just ignored otherwise."
		  "If the WBMP format specified, you can set the color index of pixels which are considered as `foreground'. The keyword is just ignored otherwise.")
		 ("ݡȤإ᡼ `im' Ϥޤեޥå `fmt' ˼ͤ \"gif\", \"jpe\", \"jpeg\", \"jpg\", \"png\", ڤ \"wbmp\" Ǥ"
		  "JPEG եޥåȤꤵ줿ˤϡ `quality' ͿͤˤäƽϤμ(ȡŪ˥)ĴǤޤΥɤͿʤˤ GD ˤäƥǥեȤͤѤޤʳΥեޥåȤˤĤƤϡñ̵뤵ޤ"
		  "WBMP եޥåȤꤵ줿ˤϡ `foreground' ˤäƥӥåȤåȤ륫顼ǥåͿ뤳ȤǤޤΥǥåʤԥ\"ط\"ȤưޤΥɤͿʤˤ GD ϥǥեȤο񤤤򤷤ޤ"))

		((method (display (im <gd-image>) &optional port)
				 (write (im <gd-image>) &optional port))
		 ("They are the same abbreviations of \"write-as\". See also \"current-gd-image-format\".")
		 ("\"write-as\" ξάǡƱ褦˿񤤤ޤ\"current-gd-image-format\" ⻲ȤƤ"))

		((method (save-as (im <gd-image>) (path <string>))
				 (save-as (im <gd-image>) (path <string>) (fmt <symbol>) &keyword quality foreground chunk-size compress))
		 ("It provides another way to output a image. It tries to create a file of path `path' even if exists and return 0 in case of success. In the former case it choices the output image format by the extension (such as \"gif\", \"jpe\", \"jpeg\", \"jpg\", \"png\", \"wbmp\", \"gd\", and \"gd2\") of the path. Explicit `fmt' is used in the latter."
		  "Available formats (if supported): GIF, JPEG, PNG, WBMP, GD, AND GD2."
		  "If the GD2 format specified, you can set the options of the resulting image by the keywords `chunk-size' and `compress'. If a true value following `compress' (default), then the image will be compressed with the given `chunk-size' (or, a default one without `chunk-size').  Otherwise it will be uncompressed."
		  "See \"write-as\" on the keyword `quality' for JPEG and `foreground' for WBMP.")
		 ("᡼Ϥ᥽åɤ1ĤǤ`path' ȤͿ줿ե(¸ǤäƤ)ޤ0֤ޤԤηǸƤФ줿硢ϥ᡼եޥåȤ `path' γĥҤˤä򤵤ޤȽ̤ĥҤ \"gif\", \"jpg\", \"jpeg\", \"jpe\", \"png\", \"wbmp\", \"gd\", \"gd2\" ǤԤηŪ˥եޥå `fmt' Ϳޤ"
		  "(ݡȤƤ)ѤǤեޥåȤ GIF, JPEG, PNG, WBMP, GD, GD2 Ǥ"
		  "GD2 եޥåȤꤵ줿硢 `chunk-size' ڤ `compress' ˤäƥץǤޤ`compress' ФƿͤͿ줿Ȥ(ǥե)ˤϡ񤭽Ф륤᡼ `chunk-size' ͤȤäư̤ޤ`chunk-size' Ϳʤ硢GD ϥǥեȤΥ򤷤ޤ`compress' ʤ鰵̤ޤ"
		  "JPEG եޥåȤΤΥ `quality'  WBMP եޥåȤΤΥ `foreground' ˤĤƤϡ\"write-as\" 򻲾ȤƤ"))

		((method (char! (im <gd-image>) (f <gd-font>) (x <integer>) (y <integer>) (c <integer>) (color <integer>) &keyword direction))
		 ("Put a character on the given `im'. If symbol 'up follows keyword `direction', \"gd-image-char-up\" is called instead of \"gd-image-char\".")
		 ("᡼ʸ񤭽Фޤ `direction' ³ƥܥ 'up ꤵ줿硢\"gd-image-char\"  \"gd-image-char-up\" ƤФޤ"))

		((method (string! (im <gd-image>) (f <gd-font>) (x <integer>) (y <integer>) (str <string>) (color <integer>) &keyword direction)
				 (string! (im <gd-image>) (fg <integer>) (font <string>) (pt <real>) (angle <real>) (x <integer>) (y <integer>) (str <string>))
				 (string! (im <gd-image>) (x <integer>) (y <integer>) (str <string>) &keyword font fg pt angle))
		 ("The first variant calls either \"gd-image-string\" or \"gd-image-string-up\" according to the symbol following keyword `direction'."
		  "The usage of the second one is consistent with \"gd-image-string-ft\"."
		  "The third, an abbreviation of the second, treats default values of parameters if not specified with keywords. See also \"current-ft-*\" and \"with-ft-font/fg/pt/angle\".")
		 ("ǽηϥ `direction' ȤȤͿ륷ܥ˽ä \"gd-image-string\" ޤ \"gd-image-string-up\" ƤӽФޤ"
		  "2ܤη \"gd-image-string-ft\" θƤӽФбޤ"
		  "Ǹη2ܤάǡɤȤȤ˥ѥ᡼ꤵʤХǥեȤͤѤޤ\"current-ft-*\"  \"with-ft-font/fg/pt/angle\" ⻲ȤƤ"))

		((parameter current-ft-font
					current-ft-fg
					current-ft-pt
					current-ft-angle)
		 ("Sometimes it is useful to fix parameters in question to print strings subsequently on an image. These are reserved for such a case and its values are referred in a call of \"string!\" without optional arguments or keywords.")
		 ("᡼Ϣ³ʸϤݡطѥ᡼ꤹʾ礬ޤäΤˤΥѥ᡼ѰդƤꡢץʥʰ䥭ɤǻꤵ줺 \"string!\" ƤФ줿˻Ȥޤ"))

		((procedure (with-ft-font/fg/pt/angle font fg pt angle thunk))
		 ("Call `thunk' with parameterized current-ft-font, current-ft-fg, current-ft-pt, and current-ft-angle. Its return value is `thunk''s one.")
		 ("current-ft-font, current-ft-fg, current-ft-pt, current-ft-angle Ϳ줿ͤˤ `thunk' ƤӤޤ `thunk' ֤ͤcurrent-ft-* ͤޤ"))

		((method (gif-anim-begin (im <gd-image>) (oport <port>) (GlobalCM <integer>) (loops <integer>))
				 (gif-anim-add (im <gd-image>) (oport <port>) (localCM <integer>) (LeftOfs <integer>) (TopOfs <integer>) (Delay <integer>) (Disposal <integer>) &optional (previm <gd-image>))
				 (gif-anim-end (oport <port>)))
		 ("Create and output a GIF Animation. In case of calling gif-anim-add without the last argument `previm', GD does not optimize the resulting frames."
		  "Rather than a pair of gif-anim-begin and gif-anim-end, gif-anim-with is often preferable.")
		 ("Υ᥽åɤˤä GIF ˥᡼Ϥޤgif-anim-add κǸΰά硢GD ϼưŪʺŬԤޤ"
		  "gif-anim-end  gif-anim-end ФˤƻȤꡢ³ gif-anim-with Ѥ뤳Ȥ򴫤ޤ"))

		((procedure (gif-anim-with im oport thunk &keyword global-cm loop))
		 ("Call `thunk' with gif-anim-began `im' and `port'. Before returning the procedure successfully, gif-anim-end is called expectedly.")
		 ("μ³ϡޤ `im'  `port' ȥɤͿ줿ͤˤ gif-anim-begin Ƥӡξ `thunk' ƤӤޤ̵˼³ gif-anim-end ƤӤޤ"))

        ((method (pixel-for-each (im <gd-image>) proc)
                 (pixel-fold (im <gd-image>) proc knil))
         ("pixel-for-each calls 'proc' once for each pixel of image 'im' with arguments: x-coordinate, y-coordinate, and its pixel value obtained by 'gd-image-get-pixel'. Its return value is unspecified."
          "This allows you to write a filter as:"
          0
          "pixel-fold calls 'proc' once for each pixel of image 'im' with 4 argumens: x-coordinate, y-coordinate, its pixel value, and the temporary seed, and returns the resulting reduction.")
         ("᥽å pixel-for-each ϳƥԥ뤴Ȥ x ɸy ɸ gd-image-get-pixel ͤ3Ĥΰ 'proc' ƤӤޤͤǤ"
          "Υ᥽åɤˤäƼΤ褦ʥե륿񤯤ȤǤޤ:"
          0
          "᥽å pixel-fold Ͻ knil Ȥˡƥԥ뤴Ȥ xyԥ͡ӤλǤξ߹ߤ줿ͤ4Ĥΰ 'proc' ƤӤޤͤϾ߹ޤ줿ͤǤ")
         "(define-method invert (im <gd-image>)
  (pixel-for-each im
                  (lambda (x y pixel)
                    (gd-image-set-pixel im x y pixel
                                        (gd-true-color (- 255 (gd-image-red im pixel))
                                                       (- 255 (gd-image-green im pixel))
                                                       (- 255 (gd-image-blue im pixel)))))))"
         )
		))

(define (document-tree lang)
  (let ((title (if (eq? 'ja lang) "Gauche-gd ե󥹥ޥ˥奢" "Gauche-gd Reference Manual")))
	(html:html
	 (html:head
	  (if (eq? 'ja lang) (html:meta :http-equiv "Content-Type" :content "text/html; charset=UTF-8") '())
	  (html:title title))
	 (html:body
	  (html:h1 title)
	  (html:style
	   :type "text/css"
	   "<!-- \n"
	   "h2 { background-color:#dddddd; }\n"
	   "address { text-align: right; }\n"
	   ".type { font-size: medium; text-decoration: underline; }\n"
	   ".procedure { font-size: medium; font-weight: normal; }\n"
	   ".method { font-size: medium; font-weight: normal; }\n"
	   ".argument { font-size: small; font-style: oblique; font-weight: normal; }\n"
	   ".constant { font-size: medium; font-weight: normal; }\n"
	   ".variable { font-size: medium; font-weight: normal; }\n"
	   "#last_update { text-align: right; font-size: small; }\n"
	   "#project { text-align: right; }\n"
	   " -->")
	  (html:p "For version " *version*)
	  (html:p :id "last_update" "last update: " *last-update*)
	  (html:p :id "project" (html:a :href "http://www.fixedpoint.jp/gauche-gd/" "http://www.fixedpoint.jp/gauche-gd/"))
	  (html:h2 "C Layer API")
	  (if (eq? 'en lang)
		  (c-layer-api en)
		  (c-layer-api ja))
	  (html:h2 "Simple API")
	  (if (eq? 'en lang)
		  (html:p "(Experimental. See graphics/gd.scm and example/*.scm if interested.)")
		  (html:p "(ޤŪʤΤǤ̣Τ graphics/gd.scm  example/*.scm 򸫤Ƥ)"))
	  (if (eq? 'en lang)
		  (simple-api en)
		  (simple-api ja))
	  (html:address "&copy; 2006-2011 Takeshi Abe")
	  ))))

(define (main args)
  (define (usage)
	(format (current-error-port) "usage: gosh reference.scm (en|ja)\n")
	(exit 1))
  (when (< (length args) 2)
	(usage))
  (write-tree (document-tree (string->symbol (cadr args))))
  0)
